<?php

namespace App\Data;

use App\Importers\Parsers\FieldParserFactory;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Support\Validation\ValidationContext;

class DataImportMappingParserData extends Data
{
    public function __construct(
        public string $rule,
        public string $args,
    )
    {
    }

    public static function rules(ValidationContext $context): array
    {
        return [
            'rule' => [
                'required',
                'string',
                'in:' . implode(',', FieldParserFactory::SUPPORTED_PARSERS),
            ],
        ];
    }
}
