<?php

namespace App\Data;

use Illuminate\Validation\Rule;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;
use Spatie\LaravelData\Support\Validation\ValidationContext;

class CreateSkuProductsFromSalesChannelData extends Data
{
    public function __construct(
        public bool $create_all_products,
        #[DataCollectionOf(DataImportMappingData::class)]
        public DataCollection|Optional $mappings,
        //TODO: Add exists rule once i figure out abstraction
        public string|null|Optional $filters = null,
        public array $ids = [],
        public bool $initial_mapping = false,
    )
    {
    }

    public static function rules(ValidationContext $context): array
    {
        return [
            'ids' => [
                Rule::requiredIf(function () use ($context) {
                    return ! $context->fullPayload['create_all_products'] && ! @$context->fullPayload['filters'];
                }),
                'array',
            ],
            'filters'
        ];
    }
}
