<?php

namespace App\Data;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class CreateInventoryMovementData extends Data
{
    public function __construct(
        public int $product_id,
        public int $quantity,
        public string $type,
        public string $inventory_status,
        public int $warehouse_id,
        public int $link_id,
        public string $link_type,
        public int $layer_id,
        public string $layer_type,
        public string $reference,
        public int|Optional $warehouse_location_id,
        public string|Optional $inventory_movement_date,
    )
    {
        if ($this->inventory_movement_date instanceof Optional) {
            $this->inventory_movement_date = now()->toDateTimeString();
        }
    }
}
