<?php

namespace App\Data;

use App\Abstractions\StockTakeItemDataInterface;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\Min;
use Spatie\LaravelData\Data;

class CreateInitialStockTakeItemData extends Data implements StockTakeItemDataInterface
{
    public int $snapshot_inventory = 0;

    public function __construct(
        #[Exists('products', 'id')]
        public int $product_id,
        #[Min(1)]
        public float $qty_counted,
        #[Min(0.01)]
        public float $unit_cost,
    )
    {
    }
}
