<?php

namespace App\Data;

use App\Models\StockTake;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;

class CreateInitialStockTakeData extends Data
{
    public bool $is_initial_count = true;
    public string $status = StockTake::STOCK_TAKE_STATUS_DRAFT;

    public function __construct(
        public string $date_count,
        #[Exists('warehouses', 'id')]
        public int $warehouse_id,
        #[DataCollectionOf(CreateInitialStockTakeItemData::class)]
        public DataCollection $items,
    )
    {
    }
}
