<?php

namespace App\Data;

use App\DTO\PurchaseOrderLineDto;
use App\Models\PurchaseOrder;
use App\Repositories\CurrencyRepository;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\RequiredWithout;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class CreateDropshipPurchaseOrderData extends Data
{
    public function __construct(
        #[Exists('sales_orders', 'id')]
        public int $sales_order_id,
        public string|Optional $purchase_order_number,
        public int|Optional $sequence,
        public string $purchase_order_date,
        #[Exists('shipping_methods', 'id'), RequiredWithout('requested_shipping_method')]
        public int|Optional $requested_shipping_method_id,
        #[RequiredWithout('requested_shipping_method_id')]
        public string|Optional $requested_shipping_method,
        #[Exists('addresses', 'id')]
        public int $destination_address_id,
        public string|null|Optional $supplier_notes,
        public string|null|Optional $internal_notes,
        public int $store_id,
        public int $supplier_id,
        #[Exists('warehouses', 'id')]
        public int $supplier_warehouse_id,
        public int|Optional $currency_id,
        public int|Optional $currency_id_tenant_snapshot,
        #[DataCollectionOf(PurchaseOrderLineDto::class)]
        public DataCollection|Optional $purchaseOrderLines,
        public string|Optional $submission_format,
        public string $receipt_status = PurchaseOrder::RECEIPT_STATUS_DROPSHIP,
    ) {
        if ($this->currency_id_tenant_snapshot instanceof Optional) {
            $this->currency_id_tenant_snapshot = app(CurrencyRepository::class)->getDefault(true)->id;
        }
    }
}
