<?php

namespace App\Data;

use App\Enums\ActionStatusEnum;
use Spatie\LaravelData\Data;

class BulkActionResultData extends Data
{
    public function __construct(
        public array $errors,
        public int $total,
        public int $success,
        public ActionStatusEnum $status = ActionStatusEnum::SUCCESS,
    )
    {
        if (count($errors) > 0) {
            $this->status = ActionStatusEnum::ERROR;
        }
    }

    public function successful(): bool
    {
        return $this->status === ActionStatusEnum::SUCCESS;
    }
}
