<?php

namespace App\Data;

use App\Models\InventoryAdjustment;
use App\Rules\StandardProductRule;
use Spatie\LaravelData\Attributes\Validation\Rule;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class BlemishedProductData extends Data
{
    public function __construct(
        #[Rule('required|unique:products,sku')]
        public string $blemished_sku,
        #[Rule(['required|exists:products,id', new StandardProductRule()])]
        public int $derived_from_product_id,
        public ?string $condition,
        public ?string $reference,
        public CreateInventoryAdjustmentFromBlemishedProductData|Optional $adjustment_data,
        public ?string $adjustment_type = InventoryAdjustment::TYPE_INCREASE,
        #[Rule('nullable|boolean')]
        public bool $adjust_inventory = false,
        public bool $adjust_inventory_for_original_product = false,
    ) {
    }
}
