<?php

namespace App\Data;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class AddressData extends Data
{
    public function __construct(
        public ?string $name,
        public ?string $label,
        public ?string $email = null,
        public ?string $company = null,
        public ?string $zip = null,
        public ?string $address1 = null,
        public ?string $address2 = null,
        public ?string $address3 = null,
        public ?string $city = null,
        public ?string $province = null,
        public string|null|Optional $province_code = null,
        public ?string $country = null,
        public string|null|Optional $country_code = null,
        public string|null|Optional $phone = null,
        public string|null|Optional $fax = null,
    ) {
    }

    public function encryptPii(): self
    {
        foreach ($this->encryptableFields() as $field)
        {
            $this->{$field} = $this->{$field} instanceof Optional ? null : encryptValue($this->{$field});
        }

        return $this;
    }

    private function encryptableFields(): array
    {
        return [
            'email',
            'address1',
            'address2',
            'address3',
            'phone',
        ];
    }
}
