<?php

namespace App\Data;

use App\Enums\AccountingTransactionLineTypeEnum;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class AccountingTransactionLineData extends Data
{
    public function __construct(
        public int|Optional $id,
        public int|Optional $accounting_transaction_id,
        public AccountingTransactionLineTypeEnum $type,
        public int $nominal_code_id,
        public string $description,
        public int $quantity,
        public float $amount,
        public float|Optional $tax_amount,
        public int|null|Optional $tax_rate_id,
        public int $link_id,
        public string $link_type,
    ) {
    }
}
