<?php

namespace App\DTO;

use App\Data\CustomerData;
use App\Data\FinancialLineData;
use App\Data\OrderLinkData;
use App\Data\SalesOrderLineData;
use App\Models\ShippingMethodMappingsSalesChannelToSku;
use App\Repositories\CurrencyRepository;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class SalesOrderDto extends Data
{
    public function __construct(
        public ?int $id,
        public string $sales_order_number,
        public int|null|Optional $sales_channel_id,
        public int|Optional $store_id,
        public string|Optional $currency_code,
        public float|Optional $currency_rate,
        public int|Optional $currency_id,
        public int|Optional $currency_id_tenant_snapshot,
        public string $order_date,
        public string|null|Optional $fulfillment_channel,
        public string|null|Optional $fulfilled_at,
        public string|null|Optional $ship_by_date,
        public string|null|Optional $deliver_by_date,
        public ?string $shipping_method_id,
        public string $requested_shipping_method,
        public bool|null|Optional $is_fba,
        public bool|null|Optional $is_replacement_order,
        public string $order_status,
        public string|Optional $fulfillment_status,
        public string|Optional $payment_status,
        public string|null|Optional $canceled_at,
        #[DataCollectionOf(SalesOrderLineData::class)]
        public DataCollection|Optional $sales_order_lines,
        #[DataCollectionOf(FinancialLineData::class)]
        public DataCollection|Optional $financial_lines,
        public CustomerData|Optional $customer,
        public PaymentDto|Optional $payment,
        public string $sales_channel_order_type,
        public string $sales_channel_order_id,
        public OrderLinkData|Optional $order_link,
        public int|null $customer_id = null,
        public int|null $shipping_address_id = null,
        public int|null $billing_address_id = null,
        public string|null|Optional $last_synced_from_sales_channel_at = null,

    ) {
        if ($this->currency_id_tenant_snapshot instanceof Optional) {
            $this->currency_id_tenant_snapshot = app(CurrencyRepository::class)->getDefault(true)->id;
        }


        if($this->shouldSetShippingMethod()) {
            $this->shipping_method_id = ShippingMethodMappingsSalesChannelToSku::firstOrCreate([
                'sales_channel_id' => $this->sales_channel_id,
                'sales_channel_method' => $this->requested_shipping_method,
            ])->shipping_method_id;
        }
    }

    private function shouldSetShippingMethod(): bool{
        return !$this->sales_channel_id instanceof Optional &&
            empty($this->shipping_method_id) &&
            !empty($this->requested_shipping_method);
    }
}
