<?php

namespace App\DTO;

use App\Repositories\CurrencyRepository;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class PaymentDto extends Data
{
    public function __construct(
        public string|Optional $sales_order_id,
        public string|Optional $link_type,
        public int|Optional $link_id,
        public string $payment_date,
        public string|Optional $payment_type,
        public int|Optional $payment_type_id,
        public string|Optional $currency_code,
        public int|Optional $currency_id,
        public float|Optional $currency_rate,
        public int|Optional $currency_id_tenant_snapshot,
        public string|Optional $external_reference,
        public float $amount
    ) {
        if ($this->currency_id_tenant_snapshot instanceof Optional) {
            $this->currency_id_tenant_snapshot = app(CurrencyRepository::class)->getDefault(true)->id;
        }
    }
}
