<?php

namespace App\DTO;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class OauthTokensDto extends Data
{
    public function __construct(
        public string $accessToken,
        public string $refreshToken,
        public int $expiresInAccessToken,
        public int $expiresInRefreshToken,
        public Optional|int $expiresAccessToken,
        public Optional|int $expiresRefreshToken,
    ) {
        $this->expiresAccessToken = $this->expiresInAccessToken + time();
        $this->expiresRefreshToken = $this->expiresInRefreshToken + time();
    }
}