<?php

namespace App\DTO;

use App\Enums\FinancialLineClassificationEnum;
use App\Enums\FinancialLineProrationStrategyEnum;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class FinancialLineTypeDto extends Data
{
    public function __construct(
        public ?int $id,
        public string|Optional $name,
        public FinancialLineClassificationEnum|Optional $classification,
        public bool|Optional $allocate_to_products,
        public FinancialLineProrationStrategyEnum|Optional $proration_strategy,
        public int|null|Optional $nominal_code_id,
    ) {
    }

    public static function rules(): array
    {
        $request = request();
        $requiredRule = $request->isMethod('POST') ? 'required' : 'sometimes';

        return [
            'name' => "$requiredRule|string",
            'classification' => "$requiredRule|string|in:".implode(',', array_column(FinancialLineClassificationEnum::cases(), 'value')),
            'allocate_to_products' => 'sometimes|boolean',
            'proration_strategy' => 'sometimes|string|in:'.implode(',', array_column(FinancialLineProrationStrategyEnum::cases(), 'value')),
            'nominal_code_id' => 'sometimes|nullable|integer|exists:nominal_codes,id',
        ];
    }
}
