<?php

namespace App\DTO;

use App\Models\User;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class DataImporterDto extends Data
{
    public function __construct(
        public string $stored_name,
        public string|Optional $original_name,
        public ?User $user = null,
        public array $meta = [],
        public array $mapping = [],
        public ?string $task_id = null,
        public array $parsers = [],
        public string $csv_enclosure = '\n',
        public string $csv_delimiter = ',',
        public bool $override = true,

    ) {
    }
}
