<?php

namespace App\DTO;

use App\Collections\AccountingTransactionLineCollection;
use Carbon\Carbon;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

/**
 * @deprecated Use AccountingTransactionData instead
 */
class AccountingTransactionDto extends Data
{
    public function __construct(
        public ?int $id,
        public Carbon $transaction_date,
        public string $type,
        public string $name,
        public string|null|Optional $email,
        public float $total,
        public string $reference,
        public bool|Optional $is_tax_included,
        public int|null|Optional $tax_rate_id,
        public float|Optional $tax_amount,
        public int $link_id,
        public string $link_type,
        public bool|Optional $is_batchable,
        public int|null|Optional $accounting_integration_id,
        public string|null|Optional $accounting_integration_type,
        public Carbon|null|Optional $submission_started_at,
        public int|null|Optional $parent_id,
        public AccountingTransactionLineCollection $accounting_transaction_lines,
    ) {
    }
}
