<?php

namespace App\Contracts\Repositories;

use App\Models\Address;
use App\Models\Customer;
use App\Models\SalesChannel;
use App\Models\SalesOrder;

interface SalesOrderRepositoryInterfaceOld
{
    /**
     * Get or Create sales order by "sales_order_number" and "sales_channel_id", then fire Sales Order events.
     */
    public function firstOrCreateSalesOrder($customer_reference, $sales_channel_id, array $otherFields): SalesOrder;

    /**
     * Validate and save Sales Order.
     */
    public function saveSalesOrder(SalesOrder $salesOrder): SalesOrder;

    /**
     * Validate an Address with required fields which enables us to save this address.
     *
     *
     *
     * @example ["status" => true]
     * @example ["status" => false, "message" => ["country_code" => ["required"]]]
     */
    public function validateAddress(Address $address, string $from): array;

    /**
     * Validate and save shipping address.
     *
     *
     * @return Address|null if validation failed return null.
     */
    public function saveShippingAddress(Address $address, SalesOrder $order): ?Address;

    /**
     * Validate and save billing address.
     *
     *
     * @return Address|null if validation failed return null.
     */
    public function saveBillingAddress(Address $address, SalesOrder $order): ?Address;

    /**
     * Get or create customer.
     *
     * If customer not get from DB, Check customer by "email" or ("name" and "zip"), if not exists create new.
     */
    public function firstOrCreateCustomer(Customer $customer, Address $address, SalesOrder $order): ?Customer;

    /**
     * Get Nominal Code by sales channel and sales channel attribute.
     */
    public function getNominalCodeBySalesChannelAttribute(SalesChannel $salesChannel, $attributeName): int;
}
