<?php

namespace App\Console\Patches\TaxRates\Patches;

use App\Models\TaxRate;
use Illuminate\Console\Command;

class DeleteUnusedTaxRates extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:tax-rates:patches:delete-unused-tax-rates';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        TaxRate::whereNotIn('id', function ($query) {
            $query->from('sales_orders')->select('tax_rate_id')->whereNotNull('tax_rate_id');
        })
            ->whereNotIn('id', function ($query) {
                $query->from('sales_order_lines')->select('tax_rate_id')->whereNotNull('tax_rate_id');
            })
            ->whereNotIn('id', function ($query) {
                $query->from('tax_rate_lines')->select('tax_rate_id')->whereNotNull('tax_rate_id');
            })
            ->delete();

        return 0;
    }
}
