<?php

namespace App\Console\Patches\Shopify\TaxRates\Patches;

use App\Models\Shopify\ShopifyOrder;
use App\Services\TaxRate\TaxRateService;
use Illuminate\Console\Command;

class FixTaxRateId extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:tax-rates:patch:fix-tax-rate-id';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        ShopifyOrder::query()
            ->whereNotNull('sku_sales_order_id')
            ->with('salesOrder')
            ->cursor()
            ->each(function ($shopifyOrder) {
                if (@$shopifyOrder->json_object['taxes_included'] && $shopifyOrder->json_object['taxes_included'] === true) {
                    $taxRates = collect($shopifyOrder->json_object['tax_lines'])
                        ->map(function ($taxRate) {
                            return [
                                'rate' => $taxRate['rate'] * 100,
                                'name' => $taxRate['title'],
                            ];
                        })
                        ->toArray();

                    $shopifyOrder->salesOrder->is_tax_included = true;
                    $shopifyOrder->salesOrder->tax_rate_id = (new TaxRateService())->getTaxRateForArray($taxRates)->id;
                    $shopifyOrder->salesOrder->update();
                }
            });

        return 0;
    }
}
