<?php

namespace App\Console\Patches\Shopify\Products\Patches;

use Illuminate\Console\Command;

class FixTimestampColumns extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:products:patch:fix-timestamp-columns';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fix created_at and updated_at for shopify_products.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        ini_set('memory_limit', '-1');

        \App\Models\Shopify\ShopifyProduct::whereNull('created_at')
            ->cursor()
            ->each(function ($product) {
                echo $product->id." \n";
                $product->created_at = $product->json_object['created_at'];
                $product->updated_at = $product->json_object['updated_at'];
                $product->update();
            });

        return 0;
    }
}
