<?php

namespace App\Console\Patches\Shopify\Products\Patches;

use App\Models\ProductListing;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class FixMismatchedVariantProducts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:orders:patch:fix-mismatched-variant-products';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $records = DB::select("
            SELECT
                pl.id as product_listings_table_id,
                pl.sales_channel_listing_id as product_listings_variant_id,
                sp.variant_id as shopify_products_variant_id,
                sp.id as shopify_products_id,
                sp.integration_instance_id as integration_instance_id
            FROM
                product_listings AS pl
                INNER JOIN shopify_products AS sp ON sp.id = pl.document_id AND pl.document_type = '\\\App\\\Models\\\Shopify\\\Mysql\\\Product'
            WHERE variant_id != sales_channel_listing_id
        ");

        collect($records)->each(function ($record) {
            $products = ProductListing::whereHas('shopifyListing', function ($query) use ($record) {
                $query->where('id', $record->shopify_products_id);
            })
                ->whereHas('salesChannel', function ($query) use ($record) {
                    $query->where('integration_instance_id', $record->integration_instance_id);
                })
                ->get();

            if ($products->count() === 1) {
                $product = $products->first();

                $product->update([
                    'sales_channel_listing_id' => $record->shopify_products_variant_id,
                ]);
            } elseif ($products->count() > 1) {
                $matchedProduct = null;

                foreach ($products as $product) {
                    if ($product->sales_channel_listing_id == $record->shopify_products_variant_id) {
                        if (is_null($matchedProduct)) {
                            $matchedProduct = $product;
                        }
                    } else {
                        $product->document_id = null;
                        $product->mysql_document_id = null;
                        $product->document_type = null;
                        $product->update();
                    }
                }

                if ($matchedProduct) {
                    \App\Models\Shopify\ShopifyProduct::where('id', $matchedProduct->document_id)
                        ->update([
                            'product' => $matchedProduct->id,
                        ]);
                }
            }
        });

        return 0;
    }
}
