<?php

namespace App\Console\Patches\Shopify\Products\Patches;

use Illuminate\Console\Command;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ConvertProductVirtualColumnsToStoredColumns extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:products:patch:convert-product-virtual-columns-to-stored-columns';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $tableSpecification = collect(DB::select('DESCRIBE shopify_products'));

        foreach ([
            'images',
            'product_title',
            'image_count',
            'removed_from_shopify',
            'price',
            'weight',
            'weight_unit',
            'inventory_quantity',
            'product_id',
            'image',
            'handle',
            'grams',
            'fulfillment_service',
            'body_html',
            'barcode',
            'admin_graphql_api_id',
            'variant_title',
            'title',
            'sku',
        ] as $variable) {
            $columnSpecification = $tableSpecification->where('Field', $variable)->first();

            if (is_null($columnSpecification) || $columnSpecification->Extra !== 'STORED GENERATED') {
                echo $variable."\n";

                if ($columnSpecification) {
                    Schema::table('shopify_products', function (Blueprint $table) use ($variable) {
                        $table->dropColumn($variable);
                    });
                }

                $statement = null;

                switch ($variable) {
                    case 'product_title':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN product_title TEXT AS(JSON_UNQUOTE(json_extract(json_object,'$.product_title'))) STORED";
                        break;

                    case 'images':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN images longtext AS(JSON_UNQUOTE(json_extract(json_object,'$.images'))) STORED";
                        break;

                    case 'image_count':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN image_count INTEGER AS(JSON_UNQUOTE(json_extract(json_object,'$.image_count'))) STORED";
                        break;

                    case 'removed_from_shopify':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN removed_from_shopify VARCHAR(10) AS(JSON_UNQUOTE(json_extract(json_object,'$.removed_from_shopify'))) STORED";
                        break;

                    case 'price':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN price DECIMAL(12,4) AS(JSON_UNQUOTE(json_extract(json_object,'$.price'))) STORED";
                        break;

                    case 'weight':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN weight VARCHAR(50) AS(JSON_UNQUOTE(json_extract(json_object,'$.weight'))) STORED";
                        break;

                    case 'weight_unit':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN weight_unit VARCHAR(50) AS(JSON_UNQUOTE(json_extract(json_object,'$.weight_unit'))) STORED";
                        break;

                    case 'inventory_quantity':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN inventory_quantity INTEGER(10) AS(JSON_UNQUOTE(json_extract(json_object,'$.inventory_quantity'))) STORED";
                        break;

                    case 'product_id':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN product_id VARCHAR(50) AS(JSON_UNQUOTE(json_extract(json_object,'$.product_id'))) STORED";
                        break;

                    case 'image':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN image TEXT AS(JSON_UNQUOTE(json_extract(json_object,'$.image'))) STORED";
                        break;

                    case 'handle':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN handle TEXT AS(JSON_UNQUOTE(json_extract(json_object,'$.handle'))) STORED";
                        break;

                    case 'grams':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN grams VARCHAR(50) AS(JSON_UNQUOTE(json_extract(json_object,'$.grams'))) STORED";
                        break;

                    case 'fulfillment_service':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN fulfillment_service VARCHAR(50) AS(JSON_UNQUOTE(json_extract(json_object,'$.fulfillment_service'))) STORED";
                        break;

                    case 'body_html':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN body_html TEXT AS(JSON_UNQUOTE(json_extract(json_object,'$.body_html'))) STORED";
                        break;

                    case 'barcode':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN barcode VARCHAR(200) AS(JSON_UNQUOTE(json_extract(json_object,'$.barcode'))) STORED";
                        break;

                    case 'admin_graphql_api_id':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN admin_graphql_api_id TEXT AS(JSON_UNQUOTE(json_extract(json_object,'$.admin_graphql_api_id'))) STORED";
                        break;

                    case 'variant_title':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN variant_title VARCHAR(200) AS(JSON_UNQUOTE(json_extract(json_object,'$.variant_title'))) STORED";
                        break;

                    case 'title':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN title VARCHAR(200) AS(JSON_UNQUOTE(json_extract(json_object,'$.title'))) STORED";
                        break;

                    case 'sku':
                        $statement = "ALTER TABLE shopify_products ADD COLUMN sku VARCHAR(200) AS(JSON_UNQUOTE(json_extract(json_object,'$.sku'))) STORED";
                        break;
                }

                DB::statement($statement);
            }
        }

        return 0;
    }
}
