<?php

namespace App\Console\Patches\Shopify\Orders\Patches;

use Illuminate\Console\Command;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ConvertVirtualColumnsToStoredColumns extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:orders:patch:convert-virtual-columns-to-stored-columns';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $tableSpecification = collect(DB::select('DESCRIBE shopify_orders'));

        foreach ([
            'name',
            'shipping_lines',
            'shipping_address',
            'email',
            'billing_address',
            'line_items',
            'discount_applications',
            'total_price',
            'currency',
            'refunds',
            'processed_at',
            'fulfillments',
            'contact_email',
            'customer',
            'updated_at',
            'created_at',
        ] as $variable) {
            $columnSpecification = $tableSpecification->where('Field', $variable)->first();

            if (is_null($columnSpecification) || $columnSpecification->Extra !== 'STORED GENERATED') {
                echo $variable."\n";

                if ($columnSpecification) {
                    Schema::table('shopify_orders', function (Blueprint $table) use ($variable) {
                        $table->dropColumn($variable);
                    });
                }

                $statement = null;

                switch ($variable) {
                    case 'name':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN name VARCHAR(200) AS(JSON_UNQUOTE(json_extract(json_object,'$.name'))) STORED";
                        break;

                    case 'customer':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN customer longtext AS(JSON_UNQUOTE(json_extract(json_object,'$.customer'))) STORED";
                        break;

                    case 'shipping_lines':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN shipping_lines longtext AS(JSON_UNQUOTE(json_extract(json_object,'$.shipping_lines'))) STORED";
                        break;

                    case 'shipping_address':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN shipping_address longtext AS(JSON_UNQUOTE(json_extract(json_object,'$.shipping_address'))) STORED";
                        break;

                    case 'email':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN email VARCHAR(200) AS(JSON_UNQUOTE(json_extract(json_object,'$.email'))) STORED";
                        break;

                    case 'billing_address':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN billing_address longtext AS(JSON_UNQUOTE(json_extract(json_object,'$.billing_address'))) STORED";
                        break;

                    case 'line_items':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN line_items longtext AS(JSON_UNQUOTE(json_extract(json_object,'$.line_items'))) STORED";
                        break;

                    case 'discount_applications':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN discount_applications longtext AS(JSON_UNQUOTE(json_extract(json_object,'$.discount_applications'))) STORED";
                        break;

                    case 'total_price':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN total_price VARCHAR(200) AS(JSON_UNQUOTE(json_extract(json_object,'$.total_price'))) STORED";
                        break;

                    case 'currency':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN currency VARCHAR(200) AS(JSON_UNQUOTE(json_extract(json_object,'$.currency'))) STORED";
                        break;

                    case 'refunds':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN refunds longtext AS(JSON_UNQUOTE(json_extract(json_object,'$.refunds'))) STORED";
                        break;

                    case 'processed_at':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN processed_at VARCHAR(50) AS(JSON_UNQUOTE(json_extract(json_object,'$.processed_at'))) STORED";
                        break;

                    case 'fulfillments':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN fulfillments longtext AS(JSON_UNQUOTE(json_extract(json_object,'$.fulfillments'))) STORED";
                        break;

                    case 'contact_email':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN contact_email TEXT AS(JSON_UNQUOTE(json_extract(json_object,'$.contact_email'))) STORED";
                        break;

                    case 'updated_at':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN updated_at TEXT AS(JSON_UNQUOTE(json_extract(json_object,'$.updated_at'))) STORED";
                        break;

                    case 'created_at':
                        $statement = "ALTER TABLE shopify_orders ADD COLUMN created_at TEXT AS(JSON_UNQUOTE(json_extract(json_object,'$.created_at'))) STORED";
                        break;
                }

                DB::statement($statement);
            }
        }

        return 0;
    }
}
