<?php

namespace App\Console\Patches\Shopify\Orders\Patches;

use Illuminate\Console\Command;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ConvertLineItemsVirtualColumnsToStoredColumns extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:orders:patch:convert-line-items-virtual-columns-to-stored-columns';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $tableSpecification = collect(DB::select('DESCRIBE shopify_order_line_items'));

        foreach ([
            'line_id',
            'variant_id',
        ] as $variable) {
            $columnSpecification = $tableSpecification->where('Field', $variable)->first();

            if (is_null($columnSpecification) || $columnSpecification->Extra !== 'STORED GENERATED') {
                echo $variable."\n";

                if ($columnSpecification) {
                    if ($variable === 'line_id') {
                        Schema::table('shopify_order_line_items', function (Blueprint $table) {
                            $table->dropForeign('shopify_order_line_items_shopify_order_id_foreign');
                            $table->dropUnique('shopify_order_line_items_shopify_order_id_line_id_unique');
                        });
                    }
                    Schema::table('shopify_order_line_items', function (Blueprint $table) use ($variable) {
                        $table->dropColumn($variable);
                    });
                }

                $statement = null;

                switch ($variable) {
                    case 'line_id':
                        $statement = "ALTER TABLE shopify_order_line_items ADD COLUMN line_id BIGINT AS(JSON_UNQUOTE(json_extract(line_item,'$.id'))) STORED";
                        break;

                    case 'variant_id':
                        $statement = "
                        ALTER TABLE shopify_order_line_items
                        ADD COLUMN variant_id BIGINT
                            AS (
                                CASE WHEN CAST(json_type(json_extract(line_item, '$.variant_id')) AS CHAR) = 'null' THEN
                                    NULL
                                ELSE
                                    JSON_UNQUOTE(json_extract(line_item, '$.variant_id'))
                                END) STORED
                        ";
                        break;
                }

                DB::statement($statement);

                if ($variable === 'line_id') {
                    Schema::table('shopify_order_line_items', function (Blueprint $table) {
                        $table->foreign('shopify_order_id')
                            ->references('id')
                            ->on('shopify_orders');

                        $table->unique(['shopify_order_id', 'line_id']);
                    });
                }
            }
        }

        return 0;
    }
}
