<?php

namespace App\Console\Patches;

use App\Models\FifoLayer;
use App\Models\InventoryMovement;
use Illuminate\Console\Command;

class SetFifoLayerWarehouses extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:set-fifo-warehouses';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sets the warehouse of fifo layers based on the initial transaction on the fifo layer.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->info('Setting warehouses for fifo layers');

        $affectedFifoLayers = FifoLayer::with([])
            ->whereDoesntHave('warehouse');

        // Progress bar
        $totalAffected = $affectedFifoLayers->count();
        $bar = $this->output->createProgressBar($totalAffected);

        // Count
        $totalFixed = 0;

        $affectedFifoLayers->each(function (FifoLayer $fifoLayer) use ($bar, &$totalFixed) {
            /** @var InventoryMovement $initialTransaction */
            $initialTransaction = $fifoLayer->inventoryMovements()->first();
            if (! $initialTransaction) {
                $bar->advance();

                return;
            }

            $fifoLayer->warehouse_id = $initialTransaction->warehouse_id;

            if ($fifoLayer->save()) {
                $totalFixed++;
            }

            $bar->advance();
        });

        $bar->finish();

        $this->info("\n{$totalFixed}/{$totalAffected} FIFO Layer warehouses fixed.");
    }
}
