<?php

namespace App\Console\Patches;

use App\Models\Warehouse;
use Illuminate\Console\Command;

class RemoveOrphanSupplierWarehouses extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:remove-orphan-supplier-warehouses';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Removes orphan supplier warehouses';

    /**
     * Create a new command instance.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $affected = Warehouse::with(['supplier'])->where('type', Warehouse::TYPE_SUPPLIER)
            ->whereDoesntHave('supplier');

        $this->info("\n{$affected->count()} orphan supplier warehouses affected.\n");

        $affected->delete();
    }
}
