<?php

namespace App\Console\Patches\Orders\Patches;

use App\Models\SalesOrder;
use Illuminate\Console\Command;

class UpdateFulfillmentStatusForOrders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:orders:patch:update-fulfillment-status-for-orders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update the fulfilment status for over fulfilled orders.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        SalesOrder::cursor()->each(function ($salesOrder) {
            if ($salesOrder->is_over_fulfilled) {
                $salesOrder->fulfillment_status = SalesOrder::FULFILLMENT_STATUS_OVER_FULFILLED;
                $salesOrder->close();
                $salesOrder->update();
            }
        });

        return 0;
    }
}
