<?php

namespace App\Console\Patches;

use App\Models\TableView;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class FixModelNamespaceData extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:fix-model-namespace-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fixes model namespace data';

    protected array $tables = [
        'inventory_movements' => ['link_type', 'layer_type'],
        'fba_inventory_movements' => ['link_type', 'layer_type'],
        'inventory_adjustments' => ['link_type'],
        'addressables' => ['addressable_type'],
        'backorder_queue_releases' => ['link_type'],
        'datatable_export_batches' => ['model', 'resource'],
        'fifo_layers' => ['link_type'],
        'order_links' => ['parent_type', 'child_type'],
        'payments' => ['link_type'],
        'personal_access_tokens' => ['tokenable_type'],
        'sales_order_line_layers' => ['layer_type'],
        'taggables' => ['taggable_type'],
        'telescope_entries_tags' => ['tag'],
    ];

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        set_time_limit(0);

        foreach ($this->tables as $table => $columns) {
            $this->output->info("Updating table: {$table}...");
            $sql = "UPDATE {$table} SET ";
            foreach ($columns as $column) {
                $sql .= " `{$column}` = REPLACE(`{$column}`, 'App\\\Model\\\', 'App\\\Models\\\'), ";
            }
            $sql = rtrim($sql, ', ');

            DB::unprepared($sql);

            $this->output->info("Table: {$table} updated.");
        }

        $this->fixTableViewsData();

        $this->output->info('Update completed!');

        return 0;
    }

    protected function fixTableViewsData()
    {
        TableView::with([])
            ->each(function (TableView $tableView) {
                $content = $tableView->content;
                foreach ($content['filters']['filterSet'] as $key => $filter) {
                    if (! empty($filter['data_type'])) {
                        if (Str::contains($filter['data_type'], 'App\\Model\\')) {
                            $content['filters']['filterSet'][$key]['data_type'] = Str::replace('App\\Model\\', 'App\\Models\\', $filter['data_type']);
                        }
                    }
                }

                foreach ($content['columns'] as $key => $column) {
                    if (! empty($column['data_type'])) {
                        if (Str::contains($column['data_type'], 'App\\Model\\')) {
                            $content['columns'][$key]['data_type'] = Str::replace('App\\Model\\', 'App\\Models\\', $column['data_type']);
                        }
                    }
                }

                $tableView->content = $content;
                $tableView->save();
            });

        $this->output->info('Table: table_views updated.');
    }
}
