<?php

namespace App\Console\Patches;

use App\Models\Supplier;
use App\Repositories\WarehouseRepository;
use Illuminate\Console\Command;

class CreatesDefaultWarehousesForSuppliers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:suppliers:default-warehouses';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Creates default warehouses for suppliers without warehouses';

    /**
     * @var WarehouseRepository
     */
    private $warehouses;

    /**
     * CreatesDefaultWarehousesForSuppliers constructor.
     */
    public function __construct(WarehouseRepository $warehouses)
    {
        parent::__construct();
        $this->warehouses = $warehouses;
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        // Get suppliers without default warehouses
        // and create default warehouse for each.
        $suppliers = Supplier::with(['defaultWarehouse'])->whereDoesntHave('defaultWarehouse')->get();

        // Progress bar
        $bar = $this->output->createProgressBar($suppliers->count());
        $bar->start();

        $suppliers->each(function (Supplier $supplier) use ($bar) {
            // Create default warehouse for the supplier.
            $this->warehouses->createDefaultWarehouseForSupplier($supplier);
            $bar->advance();
        });

        $bar->finish();
        $this->info("\nDefault warehouses created for {$suppliers->count()} suppliers.");
    }
}
