<?php

namespace App\Console\Commands\Telescope;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Symfony\Component\Console\Command\Command as CommandAlias;

class DbCreate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'telescope:db:create';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create MySQL tables for Telescope.';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $this->createTables();

        return CommandAlias::SUCCESS;
    }

    public function createTables(): void
    {
        // This operation is only available for MySQL.
        $connection_name = config('telescope.storage.database.connection');
        $telescope_conn = DB::connection($connection_name);
        if (! $telescope_conn) {
            $this->error('No Telescope Connection configured');

            return;
        }

        $username = config('database.connections.'.$connection_name.'.username', false);
        $password = config('database.connections.'.$connection_name.'.password', false);
        $hostname = config('database.connections.'.$connection_name.'.host', false);
        $port = config('database.connections.'.$connection_name.'.port', false);
        $database = config('database.connections.'.$connection_name.'.database', false);

        $filepath = database_path('schema/mysql-telescope-schema.dump');

        $command = sprintf(
            '%s --user=%s --password=%s --host=%s --port=%s %s < %s',
            'mysql',
            escapeshellarg($username),
            escapeshellarg($password),
            escapeshellarg($hostname),
            escapeshellarg($port),
            escapeshellarg($database),
            escapeshellarg($filepath)
        );

        DB::connection('telescope')->statement('CREATE DATABASE IF NOT EXISTS `'.$database.'`;');

        $output = [];
        $exit_code = 0;

        exec($command, $output, $exit_code);

        if ($exit_code) {
            $this->error('Error creating tables');
            $this->info('Command: '.$command);
            $this->info(implode($output));
        } else {
            $this->info('Telescope database and tables created successfully.');
        }
    }
}
