<?php

namespace App\Console\Commands\Starshipit;

use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class GetTrackingCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:starshipit:get-tracking';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get order tracking from Starshipit';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $integrationInstance = IntegrationInstance::starshipit()->first();

        if (! $integrationInstance) {
            $this->error('There is no instance for Starshipit');

            return;
        }

        dispatch(new \App\Jobs\Starshipit\GetTrackingJob($integrationInstance));

        $this->info('Added to the Queue, it will be process shortly');
    }
}
