<?php

namespace App\Console\Commands\Shopify;

use App\Console\Commands\AbstractIntegrationInstanceCommand;
use App\Jobs\Shopify\ShopifyPurgeOldWebhooksJob;
use App\Models\IntegrationInstance;
use Throwable;

class ShopifyPurgeOldWebhookEventsCommand extends AbstractIntegrationInstanceCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:webhook-events:purge {integrationInstanceId?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Purge old Shopify webhook events';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (IntegrationInstance $integrationInstance) {
            dispatch(new ShopifyPurgeOldWebhooksJob($integrationInstance));
        });
    }
}
