<?php

namespace App\Console\Commands\Shopify;

use App\Console\Commands\AbstractIntegrationInstanceCommand;
use App\Jobs\Shopify\ShopifyProcessWebhooksJob;
use App\Models\IntegrationInstance;
use Illuminate\Support\Facades\Bus;
use Throwable;

class ShopifyProcessWebhookEventsCommand extends AbstractIntegrationInstanceCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:webhook-events:process {integrationInstanceId?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process Shopify webhook events';

    /**
     * Execute the console command.
     *
     * @throws Throwable
     */
    public function handle(): int
    {
        $chained_jobs = [];

        $this->integrationInstances()->each(function (IntegrationInstance $integrationInstance) use (&$chained_jobs) {
            $chained_jobs[] = new ShopifyProcessWebhooksJob($integrationInstance);
        });

        if (! empty($chained_jobs)) {
            Bus::chain($chained_jobs)->onQueue('sales-channels')->dispatch();
        }

        return 0;
    }
}
