<?php

namespace App\Console\Commands\Shopify;

use App\Console\Commands\AbstractIntegrationInstanceCommand;
use App\Jobs\Shopify\ShopifyDeletedProductEventsJob;
use App\Models\IntegrationInstance;

class ShopifyDeleteProductEventsCommand extends AbstractIntegrationInstanceCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:delete-product-events {integrationInstanceId?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get product delete events for Shopify';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (IntegrationInstance $integrationInstance) {
            dispatch(new ShopifyDeletedProductEventsJob($integrationInstance))->onQueue('sales-channels');
        });
    }
}
