<?php

namespace App\Console\Commands\Shopify;

use App\Jobs\Shopify\ShopifyDeleteMissingProductVariantsJob;
use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class ShopifyDeleteMissingProductVariantsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shopify:delete-missing-product-variants
                          {integrationInstance : The ID of the integration instance}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Download all product variants and compare them with what exists in order to delete the missing ones.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        /** @var IntegrationInstance $integrationInstance */
        $integrationInstance = IntegrationInstance::with('integration')->findOrFail($this->argument('integrationInstance'));
        if (! $integrationInstance || ! $integrationInstance->isShopify()) {
            $this->error('The integration must be Shopify.');

            return;
        }

        dispatch(new ShopifyDeleteMissingProductVariantsJob($integrationInstance))->onQueue('sales-channels');

        $this->info('Added Shopify delete missing product variants to the queue, it will be processed shortly.');
    }

    protected function getCommandOptions(): array
    {
        $options = [];

        if ($this->option('ids')) {
            $options['ids'] = implode(',', $this->option('ids'));
        }

        return $options;
    }
}
