<?php

namespace App\Console\Commands\ShipStation;

use Illuminate\Console\Command;
use Illuminate\Support\Arr;

class GetOrders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:shipstation:get-orders
                            {--customerName= : Returns orders that match the specified name.}
                            {--createDateStart= : Returns orders that were created in ShipStation after the specified date.}
                            {--createDateEnd= : Returns orders that were created in ShipStation before the specified date.}
                            {--modifyDateStart= : Returns orders that were modified after the specified date.}
                            {--modifyDateEnd= : Returns orders that were modified before the specified date.}
                            {--orderDateStart= : Returns orders greater than the specified date.}
                            {--orderDateEnd= : Returns orders less than or equal to the specified date.}
                            {--orderNumber= : Filter by order number, performs a "starts with" search.}
                            {--s|orderStatus=* : A list of orderStatus values.}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get a list of orders that match the specified criteria from ShipStation';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $job = new \App\Jobs\ShipStation\GetOrders();
        $job->setRequestOptions(Arr::except(array_filter($this->options()), $this->getBuiltInOptions()));

        dispatch($job);

        $this->info('Added to the Queue, it will be process shortly');
    }

    private function getBuiltInOptions()
    {
        return [
            'help',
            'quiet',
            'verbose',
            'version',
            'ansi',
            'no-ansi',
            'no-interaction',
            'env',
        ];
    }
}
