<?php

namespace App\Console\Commands;

use Database\Seeders\DatabaseConstantsSeeder;
use Database\Seeders\ImmutableData\IntegrationsSeeder;
use Database\Seeders\ImmutableData\SalesChannelFieldDefinitionsSeeder;
use Database\Seeders\ImmutableData\SalesChannelsSeeder;
use Database\Seeders\ImmutableData\TaxRateSeeder;
use Database\Seeders\InitialData\CurrenciesSeeder;
use Database\Seeders\InitialData\IncotermsSeeder;
use Database\Seeders\InitialData\NominalCodesSeeder;
use Database\Seeders\InitialData\PaymentTermsSeeder;
use Database\Seeders\InitialData\PaymentTypeSeeder;
use Database\Seeders\InitialData\ProductPricingTiersSeeder;
use Database\Seeders\InitialData\ReturnReasonSeeder;
use Database\Seeders\InitialData\SettingsSeeder;
use Database\Seeders\InitialData\ShippingCarriersSeeder;
use Database\Seeders\InitialData\StoreEmailTemplateSeeder;
use Database\Seeders\InitialData\SupplierSeeder;
use Database\Seeders\InitialData\UsersSeeder;
use Database\Seeders\InitialData\WarehouseSeeder;
use Database\Seeders\InitialData\ZipLocationsSeeder;
use Illuminate\Console\Command;

class SetupCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:setup {--skip-constants}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Setup SKU data';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        // Set up initial admin User if no user exists
        $this->call(UsersSeeder::class);

        // Set up immutable data
        if (! $this->option('skip-constants')) {
            $this->call(DatabaseConstantsSeeder::class);
        }
        $this->call(IntegrationsSeeder::class);
        $this->call(SalesChannelFieldDefinitionsSeeder::class);
        $this->call(SalesChannelsSeeder::class);
        $this->call(TaxRateSeeder::class);

        // Set up initial data if no records exist
        $this->call(CurrenciesSeeder::class);
        $this->call(PaymentTermsSeeder::class);
        /*
         * TODO: PaymentTypeSeeder needs to be added but it's currently causing tests to fail and not sure why.
         */
        $this->call(PaymentTypeSeeder::class);
        $this->call(IncotermsSeeder::class);
        $this->call(ShippingCarriersSeeder::class);
        $this->call(NominalCodesSeeder::class);
        $this->call(ProductPricingTiersSeeder::class);
        $this->call(WarehouseSeeder::class);
        $this->call(SettingsSeeder::class);
        $this->call(SupplierSeeder::class);
        $this->call(StoreEmailTemplateSeeder::class);
        $this->call(ReturnReasonSeeder::class);
        $this->call(ZipLocationsSeeder::class);
    }
}
