<?php

namespace App\Console\Commands;

use Database\Seeders\ImportLastMappingTableSeeder;
use Database\Seeders\SampleData\AddressesTableSeeder;
use Database\Seeders\SampleData\AttributeGroupsTableSeeder;
use Database\Seeders\SampleData\AttributesTableSeeder;
use Database\Seeders\SampleData\CurrenciesTableSeeder;
use Database\Seeders\SampleData\CustomersTableSeeder;
use Database\Seeders\SampleData\IntegrationInstancesTableSeeder;
use Database\Seeders\SampleData\ProductAttributesTableSeeder;
use Database\Seeders\SampleData\ProductBrandsTableSeeder;
use Database\Seeders\SampleData\ProductCategoriesTableSeeder;
use Database\Seeders\SampleData\ProductImagesTableSeeder;
use Database\Seeders\SampleData\ProductPricingTableSeeder;
use Database\Seeders\SampleData\ProductsTableSeeder;
use Database\Seeders\SampleData\ProductToCategoriesTableSeeder;
use Database\Seeders\SampleData\SalesChannelsTableSeeder;
use Database\Seeders\SampleData\ShopifyLocationsTableSeeder;
use Database\Seeders\SampleData\StoresTableSeeder;
use Database\Seeders\SampleData\SupplierInventoryTableSeeder;
use Database\Seeders\SampleData\SupplierPricingTiersTableSeeder;
use Database\Seeders\SampleData\SupplierProductPricingTableSeeder;
use Database\Seeders\SampleData\SupplierProductsTableSeeder;
use Database\Seeders\SampleData\SuppliersTableSeeder;
use Database\Seeders\SampleData\SupplierToPricingTierTableSeeder;
use Database\Seeders\SampleData\TableViewsTableSeeder;
use Database\Seeders\SampleData\TaxRatesTableSeeder;
use Database\Seeders\SampleData\WarehouseLocationsTableSeeder;
use Database\Seeders\SampleData\WarehousesTableSeeder;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Schema;

class SampleDataCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:sample-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Setup SKU Sample Data (for development only)';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        if (app()->environment('production')) {
            $this->error('This command is only available in development environments.');

            return;
        }

        Schema::disableForeignKeyConstraints();
        $this->call(StoresTableSeeder::class);
        $this->call(SuppliersTableSeeder::class);
        $this->call(WarehousesTableSeeder::class);
        $this->call(AddressesTableSeeder::class);
        $this->call(CurrenciesTableSeeder::class);
        $this->call(CustomersTableSeeder::class);
        $this->call(TaxRatesTableSeeder::class);
        $this->call(WarehouseLocationsTableSeeder::class);
        $this->call(ProductAttributesTableSeeder::class);
        $this->call(ProductBrandsTableSeeder::class);
        $this->call(ProductImagesTableSeeder::class);
        $this->call(ProductPricingTableSeeder::class);
        $this->call(SupplierProductPricingTableSeeder::class);
        $this->call(ProductsTableSeeder::class);
        $this->call(SupplierInventoryTableSeeder::class);
        $this->call(SupplierProductsTableSeeder::class);
        $this->call(SupplierToPricingTierTableSeeder::class);
        $this->call(AttributesTableSeeder::class);
        $this->call(ProductCategoriesTableSeeder::class);
        $this->call(AttributeGroupsTableSeeder::class);
        $this->call(ProductToCategoriesTableSeeder::class);
        $this->call(SupplierPricingTiersTableSeeder::class);
        $this->call(TableViewsTableSeeder::class);
        $this->call(IntegrationInstancesTableSeeder::class);
        $this->call(SalesChannelsTableSeeder::class);
        $this->call(ShopifyLocationsTableSeeder::class);
        $this->call(ImportLastMappingTableSeeder::class);
        Schema::enableForeignKeyConstraints();
    }
}
