<?php

namespace App\Console\Commands;

use App\Jobs\UpdateProductsInventoryAndAvgCost;
use App\Models\FifoLayer;
use App\Models\InventoryMovement;
use App\Models\SalesOrderFulfillmentLine;
use App\Models\SalesOrderLine;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\DB;

class ReverseOrphanFulfillments extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:fulfillments:reverse-orphans
                            {--p|products=* : Products to reverse orphans for.}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Reverses orphan fulfillments.';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $affectedProducts = [];

        // TODO:: THIS CODE NEEDS REVIEW, DON'T USE IT YET.
        return;
        $query = InventoryMovement::query()
            ->with(['link'])
            ->selectRaw(DB::raw('inventory_movements.id as id, inventory_movements.product_id, 
            inventory_movements.link_type, inventory_movements.link_id, inventory_movements.quantity as fulfilled_inventory_quantity, 
            sofl.quantity as fulfilled_quantity, im.quantity as line_inventory_quantity'))
            ->join('sales_order_fulfillment_lines as sofl', function ($join) {
                $join->on('inventory_movements.link_id', 'sofl.id')
                    ->where('inventory_movements.link_type', SalesOrderFulfillmentLine::class);
            })
            ->leftJoin('inventory_movements as im', function ($join) {
                $join->on('sofl.sales_order_line_id', 'im.link_id')
                    ->where('im.link_type', SalesOrderLine::class);
            })
            ->where(function (Builder $builder) {
                return $builder->whereNull('im.link_id')
                    ->orWhere(function (Builder $builder) {
                        return $builder->where('im.quantity', '<', 0)
                            ->where('im.inventory_status', InventoryMovement::INVENTORY_STATUS_ACTIVE)
                            ->whereColumn('im.quantity', '!=', 'inventory_movements.quantity');
                    });
            });

        if (! empty($this->option('products'))) {
            $query = $query->whereIn('inventory_movements.product_id', $this->option('products'));
        }

        $query->whereColumn('inventory_movements.layer_id', 'im.layer_id')
            ->where('inventory_movements.layer_type', FifoLayer::class)
            ->where('im.layer_type', FifoLayer::class);

        $query->cursor()
            ->each(function ($fulfillmentMovement) use (&$affectedProducts) {
                DB::transaction(function () use ($fulfillmentMovement, &$affectedProducts) {
                    if (is_null($fulfillmentMovement->line_inventory_quantity)) {
                        // The accompanying inventory movements for the sales order are unavailable,
                        // this fulfillment line shouldn't exist.
                        /** @var SalesOrderFulfillmentLine $fulfillmentLine */
                        $fulfillmentLine = $fulfillmentMovement->link;
                        // Fulfillment has no lines, we delete it
                        // ignoring shipping provider exceptions.
                        // We need to delete the fulfillment in sku.
                        $fulfillmentLine->deleteWithFulfillmentIfLast(true);
                    } else {
                        // The fulfilled quantity and its inventory movement quantity exceed what's presently
                        // on the sales order. We synchronize the quantities.
                        $this->syncFulfillmentQuantity($fulfillmentMovement->link, $fulfillmentMovement->line_inventory_quantity);
                    }

                    $affectedProducts[] = $fulfillmentMovement->product_id;
                });
            });

        $affectedProducts = array_unique($affectedProducts);

        // Update product inventory cache for the affected products.
        dispatch_sync(new UpdateProductsInventoryAndAvgCost($affectedProducts));

        $this->output->info('Reversed orphan fulfillments for '.count($affectedProducts).' products.');

    }

    private function syncFulfillmentQuantity(SalesOrderFulfillmentLine $fulfillmentLine, int $lineQuantity): void
    {
        $fulfillmentLine->quantity = abs($lineQuantity);
        $fulfillmentLine->save();

        // Update inventory movement
        $fulfillmentLine->inventoryMovements()->update(['quantity' => $lineQuantity]);
    }
}
