<?php

namespace App\Console\Commands;

use App\Helpers;
use App\Jobs\ProcessNewInventory;
use Facades\App\Services\InventoryManagement\Actions\ReleaseBackorderQueues as ReleaseBackorder;
use Illuminate\Console\Command;

class ReleaseBackorderQueues extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:release-backorder-queues
                            {--p|products=* : Specify products }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Attempts to release backorder queues for the given product';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        set_time_limit(0);

        if (Helpers::isJobRunning(ProcessNewInventory::class)) {
            // To prevent conflicts, we only run if we're not processing new inventory.
            return;
        }

        [$total, $processed, $errored] = ReleaseBackorder::release($this->option('products'));

        $this->output->info("Processed: $processed of $total");
        $this->output->info("Errored: $errored of $total");

    }
}
