<?php

namespace App\Console\Commands;

use App\Models\TaskStatus\TaskStatus;
use Illuminate\Console\Command;

class PruneTaskStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:prune-task-status';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Prunes the task status table';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        // Delete all tasks status records more than 24 hours ago.
        TaskStatus::query()
            ->whereDate('created_at', '<', now()->subHours(24))
            ->delete();

        return Command::SUCCESS;
    }
}
