<?php

namespace App\Console\Commands\Patches;

use App\Models\Product;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class SetBundleComponentQuantityCacheOnSalesOrderLines extends Command
{

    protected $signature = 'sku:orders:patch:set-bundle-quantity-cache-on-sales-order-lines';
    protected $description = 'Set the bundle quantity cache on sales order lines.';

    public function handle(): int
    {
        $this->info('Setting bundle quantity cache on sales order lines...');


        DB::table('sales_order_lines as sol')
            ->join('product_components as pc', 'sol.bundle_id', '=', 'pc.parent_product_id')
            ->join('products as p', 'p.id', '=', 'sol.bundle_id')
            ->whereNull('sol.bundle_component_quantity_cache')
            ->where('p.type', '=', Product::TYPE_BUNDLE)
            ->whereColumn('sol.product_id', 'pc.component_product_id')
            ->update(['sol.bundle_component_quantity_cache' => DB::raw('pc.quantity')]);


        $this->info('Bundle quantity cache set on sales order lines.');

        return 0;
    }

}