<?php

namespace App\Console\Commands\Patches;

use App\Models\PurchaseOrderShipmentReceiptLine;
use DB;
use Illuminate\Console\Command;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use App\Models\PurchaseOrderShipmentReceipt;
use Throwable;

class ConsolidateFbaPurchaseOrderShipmentReceiptsCommand extends Command
{
    protected $signature = 'patch:consolidate-fba-purchase-order-shipment-receipts';

    protected $description = 'Patch to consolidate FBA purchase order shipment receipts.';

    public function handle(): void
    {
        $ledgers = AmazonFbaReportInventoryLedger::query()
            ->where("sku_link_type", PurchaseOrderShipmentReceiptLine::class)
            ->get();

        $ledgers->each(/**
         * @throws Throwable
         */ function (AmazonFbaReportInventoryLedger $ledger) use (&$i) {
            DB::transaction(function () use ($ledger) {
                /** @var PurchaseOrderShipmentReceiptLine $receiptLine */
                $receiptLine = $ledger->skuLink;
                $receipt = $receiptLine->purchaseOrderShipmentReceipt;
                $shipmentLine = $receiptLine->purchaseOrderShipmentLine;
                $shipment = $shipmentLine->purchaseOrderShipment;
                $purchaseOrder = $shipment->purchaseOrder;

                // Check if receipt exists with same date and same po

                $sameReceipts = PurchaseOrderShipmentReceipt::query()
                    ->whereHas("purchaseOrderShipment", function ($query) use (
                        $purchaseOrder
                    ) {
                        $query->whereHas("purchaseOrder", function ($query) use (
                            $purchaseOrder
                        ) {
                            $query->where("id", $purchaseOrder->id);
                        });
                    })
                    ->where("received_at", $receipt->received_at)
                    ->where("id", "!=", $receipt->id)
                    ->get();
                if ($sameReceipts->count() > 0) {
                    $this->info(
                        $purchaseOrder->purchase_order_number .
                            " has " .
                            $sameReceipts->count() .
                            " receipts with the same receipt date that can be consolidated " .
                            $receipt->received_at->toDateTimeString()
                    );
                    // for each same receipt, move the lines to the receipt and if the same receipt has no more lines then delete it.  Also, move the shipment line to the same shipment and if the shipment has no more lines then delete it
                    $sameReceipts->each(function (
                        PurchaseOrderShipmentReceipt $matchingReceipt
                    ) use ($receipt) {
                        $matchingReceipt->purchaseOrderShipmentReceiptLines->each(function (
                            PurchaseOrderShipmentReceiptLine $matchingReceiptLine
                        ) use ($receipt) {
                            $this->info(
                                $matchingReceiptLine->id .
                                    " receipt line id needs to be moved to receipt " .
                                    $receipt->id
                            );
                            $matchingReceiptLine->purchase_order_shipment_receipt_id =
                                $receipt->id;
                            $matchingReceiptLine->save();
                            $matchingShipmentLine =
                                $matchingReceiptLine->purchaseOrderShipmentLine;
                            $matchingShipmentLine->purchase_order_shipment_id =
                                $receipt->purchase_order_shipment_id;
                            $matchingShipmentLine->save();
                        });
                        $matchingShipment = $matchingReceipt->purchaseOrderShipment;
                        $matchingReceipt->refresh();
                        $matchingShipment->refresh();

                        if (
                            $matchingReceipt->purchaseOrderShipmentReceiptLines()->count() == 0
                        ) {
                            $this->info(
                                "old Receipt " .
                                    $matchingReceipt->id .
                                    " now has no lines so deleting"
                            );
                            $matchingReceipt->delete();
                        }
                        if ($matchingShipment->purchaseOrderShipmentLines()->count() == 0) {
                            $this->info(
                                "old Shipment " .
                                    $matchingShipment->id .
                                    " now has no lines so deleting"
                            );
                            $matchingShipment->delete();
                        }
                    });
                }
            });
        });
    }
}
