<?php

namespace App\Console\Commands;

use App\Jobs\PackingSlipHandlerJob;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Redis;

class PackingSlipHandlerRestartCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:packing-slip-handler:restart';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'restart the packing slip handler';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        Redis::connection()->set(PackingSlipHandlerJob::RESTART_KEY, now()->getTimestamp());

        return Command::SUCCESS;
    }
}
