<?php

namespace App\Console\Commands;

use App\Jobs\PackingSlipHandlerJob;
use Illuminate\Console\Command;

class PackingSlipHandlerCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:packing-slip-handler';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Manage packing slips generation';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $this->info('Packing Slip Generation Handler started successfully');

        PackingSlipHandlerJob::dispatchSync();

        return Command::SUCCESS;
    }
}
