<?php

namespace App\Console\Commands\Magento;

use App\Jobs\Magento\SyncMagentoPricingJob;
use App\Jobs\Magento\SyncSkuPricingJob;
use App\Models\IntegrationInstance;
use Illuminate\Console\Command;

class SyncPricingCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:magento:sync-pricing
                                {integrationInstance : The ID of the integration instance}
                                {--debug : Do not queue, run inline }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync pricing';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        /** @var IntegrationInstance $integrationInstance */
        $integrationInstance = $this->argument('integrationInstance') instanceof IntegrationInstance ? $this->argument('integrationInstance') : IntegrationInstance::with(['integration'])->findOrFail($this->argument('integrationInstance'));

        if (! $integrationInstance->isMagento()) {
            $this->error('The integration instance type must be Magento');

            return 0;
        }

        if ($this->option('debug')) {
            // Sync pricing from Magento To SKU
            dispatch_sync(new SyncSkuPricingJob($integrationInstance));
            // Sync pricing from SKU to Magento
            dispatch_sync(new SyncMagentoPricingJob($integrationInstance));
        } else {
            // Sync pricing from Magento To SKU
            dispatch(new SyncSkuPricingJob($integrationInstance))->onQueue('sales-channels');
            // Sync pricing from SKU to Magento
            dispatch(new SyncMagentoPricingJob($integrationInstance))->onQueue('sales-channels');
        }
    }
}
