<?php

namespace App\Console\Commands\Inventory;

use App\Jobs\RecalculateFifoLayerCostsJob;
use Illuminate\Console\Command;

class RecalculateFifoLayerCostsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:inventory:recalculate-fifo-layer-costs
                            {--ids|ids= : Specify fifo layer ids (CSV) }
                            {--with-discounts-only : Recalculate only where the purchase order lines had discounts }
                            {--with-non-default-currency-only : Recalculate only where the purchase order had a non-default currency }
                            {--startDate= : Specify the fifo layer start date}
                            {--endDate= : Specify the fifo layer end date}
                            ';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Recalculate fifo layer costs, sales order line financials, and accounting transaction lines';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $ids = $this->option('ids') ? explode(',', $this->option('ids')) : [];

        dispatch(new RecalculateFifoLayerCostsJob($ids, [
            'withDiscountsOnly' => $this->option('with-discounts-only'),
            'withNonDefaultCurrencyOnly' => $this->option('with-non-default-currency-only'),
            'startDate' => $this->option('startDate'),
            'endDate' => $this->option('endDate'),
        ]))->onQueue('recalculations');
    }
}
