<?php

namespace App\Console\Commands\Inventory\Health\Fix;

use App\Console\Commands\Inventory\Health\AbstractInventoryHealthCommandHelper;
use App\Console\Commands\Inventory\Health\Fix\Traits\FixInventoryMovementsTrait;
use App\Models\InventoryMovement;
use App\Models\SalesOrderLine;
use Illuminate\Database\Eloquent\Builder;
use Throwable;

class FixFulfillmentReleaseInventoryMovementsMissingFulfillmentLinesCommandHelper extends AbstractInventoryHealthCommandHelper
{
    use FixInventoryMovementsTrait;

    public function getDescription(): string
    {
        return 'Fix Fulfillment Release Inventory Movements Missing Fulfillment Lines';
    }

    public function getQuery(): Builder
    {
        return $this->health->fulfillmentReleaseInventoryMovementsMissingFulfillmentLinesQuery();
    }

    /** @var InventoryMovement $dataItem */
    protected function getFixLabel(mixed $dataItem): string
    {
        return "Fixing for inventory movement $dataItem->id line with SKU {$dataItem->product->sku} for quantity $dataItem->quantity (Reference: $dataItem->reference)";
    }

    /**
     * @throws Throwable
     * @var SalesOrderLine $dataItem
     */
    protected function fix($dataItem): void
    {
        $dataItem->delete();
    }
}