<?php

namespace App\Console\Commands\Inventory;

use App\Jobs\ForecastInventoryJob as ForecastJob;
use Illuminate\Console\Command;
use Illuminate\Contracts\Container\BindingResolutionException;

class ForecastInventoryCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:inventory:forecast';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Runs the inventory forecast';

    /**
     * @throws BindingResolutionException
     */
    public function handle(): int
    {
        dispatch(app()->make(ForecastJob::class));

        return 0;
    }
}
