<?php

namespace App\Console\Commands;

use App\Models\SalesChannel;
use App\Models\SalesChannelType;
use Exception;
use Illuminate\Console\Command;

abstract class GetOrders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:name';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * The console command Sales Channel Type.
     *
     * @var string
     */
    protected $salesChannelType;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     *
     * @throws Exception
     */
    public function handle(): void
    {
        /**
         * Check if command has salesChannel argument.
         */
        if (! $this->hasArgument('salesChannel')) {
            $this->error('Get orders command must have an "salesChannel" argument');

            return;
        }

        if (empty($this->salesChannelType)) {
            $this->error('Must assign value for "salesChannelType" attribute');

            return;
        }

        /**
         * Get Sales channel and check the sales channel type.
         */
        $sales_channel = SalesChannel::with('type')->findOrFail($this->argument('salesChannel'));

        if (SalesChannelType::getTypeByID($sales_channel->sales_channel_type_id) !== $this->salesChannelType) {
            $this->error('The type of Sales Channel must be '.$this->salesChannelType);

            return;
        }

        $this->handleCommand($sales_channel);
    }

    /**
     * Execute the console command of Sales channel type.
     *
     *
     * @return void
     */
    abstract public function handleCommand(SalesChannel $salesChannel);
}
